#ifndef PSX_MAIN_WINDOW_HPP
#define PSX_MAIN_WINDOW_HPP

#include <atlbase.h>
#include <atlapp.h>
#include <atlwin.h>
#include <atlmisc.h>
#include <atlframe.h>
#include <atlcrack.h>
#include <EFramework.hpp>

#include "PSXPluginDialog.hpp"
#include "PSXIdleHandler.hpp"
#include "../resource.h"

namespace NeoPSX
{
	/// The main window class definition.
	class PSXMainWindow : public CFrameWindowImpl< PSXMainWindow >, public CUpdateUI< PSXMainWindow >
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// WTL Macro Declarations - CFrameWindowImpl and CUpdateUI

		DECLARE_FRAME_WND_CLASS(_T("NeoPSX"), IDR_MAINFRAME);

		BEGIN_MSG_MAP_EX( PSXMainWindow )
			MESSAGE_HANDLER(WM_CREATE, OnCreate)
			MESSAGE_HANDLER(WM_CLOSE , OnClose)
			MESSAGE_HANDLER(WM_PAINT , OnPaint )

			COMMAND_RANGE_HANDLER_EX(ID_FILE_MRU_FIRST, ID_FILE_MRU_LAST, OnFileRecent)
			COMMAND_ID_HANDLER(ID_FILE_EXIT   , OnFileExit)
			COMMAND_ID_HANDLER(ID_FILE_RUNEXE, OnFileOpenExe)
			COMMAND_ID_HANDLER(ID_FILE_RUNISO, OnFileOpenIso)

			COMMAND_ID_HANDLER(ID_DEBUGGER_CPUDEBUGGER, OnDebugCpu)
			COMMAND_ID_HANDLER(ID_SETTINGS_GRAPHICS   , OnConfigureVideo)
			COMMAND_ID_HANDLER(ID_SETTINGS_SOUND      , OnConfigureSound)
			COMMAND_ID_HANDLER(ID_SETTINGS_CD         , OnConfigureCdrom)
			COMMAND_ID_HANDLER(ID_SETTINGS_CONTROLLER1, OnConfigurePad1)
			COMMAND_ID_HANDLER(ID_SETTINGS_CONTROLLER2, OnConfigurePad2)
			COMMAND_ID_HANDLER(ID_SETTINGS_EMULATION  , OnConfigureEmulation)

			COMMAND_ID_HANDLER_EX(ID_VIEW_STATUSBAR, OnViewStatusbar)

			COMMAND_ID_HANDLER(ID_HELP_ABOUT  , OnHelpAbout)

			CHAIN_MSG_MAP( CUpdateUI< PSXMainWindow > )
			CHAIN_MSG_MAP( CFrameWindowImpl< PSXMainWindow > )
		END_MSG_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// WTL Macro Declarations - CUpdateUI

		BEGIN_UPDATE_UI_MAP( PSXMainWindow )
			UPDATE_ELEMENT(ID_VIEW_STATUSBAR, UPDUI_MENUPOPUP)
		END_UPDATE_UI_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
	    PSXMainWindow();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Window Message Handler Functions

		/** Handle the window creation message.
		  */
		LRESULT OnCreate   (UINT, WPARAM, LPARAM, BOOL);
		/** Handles the saving of settings and window destruction.
		  */
		LRESULT OnClose    (UINT, WPARAM, LPARAM, BOOL);
		/** Handle painting of the main widnow.
		  */
		LRESULT OnPaint    (UINT, WPARAM, LPARAM, BOOL);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Menu Message Handler Functions

		/** Handles the shutdown of all the components and destructor of the window.
		  */
		LRESULT OnFileExit(WORD, WORD, HWND, BOOL);
		/** Displays an open file dialog box and opens the specified Playstation executable.
		  */
		LRESULT OnFileOpenExe(WORD, WORD, HWND, BOOL);
		/** Displays an open file dialog box and opens the specified ISO file.
		  */
		LRESULT OnFileOpenIso(WORD, WORD, HWND, BOOL);
		/** The recent file open popup
		  */
		void OnFileRecent(UINT, int nID, CWindow);
		/** Configures settings for video plugins.
		  */
		LRESULT OnConfigureVideo(WORD, WORD, HWND, BOOL);
		/** Configures settings for sound plugins.
		  */
		LRESULT OnConfigureSound(WORD, WORD, HWND, BOOL);
		/** Configures settings for cdrom plugins.
		  */
		LRESULT OnConfigureCdrom(WORD, WORD, HWND, BOOL);
		/** Configures settings for pad1 plugins.
		  */
		LRESULT OnConfigurePad1(WORD, WORD, HWND, BOOL);
		/** Configures settings for pad2 plugins.
		  */
		LRESULT OnConfigurePad2(WORD, WORD, HWND, BOOL);
		/** Opens the emulation configuration dialog box.
		  */
		LRESULT OnConfigureEmulation(WORD, WORD, HWND, BOOL);
		/** Shows/Hides the status bar.
		  */
		void OnViewStatusbar(WORD, int, CWindow);
		/** Displays the about dialog box.
		  */
		LRESULT OnHelpAbout(WORD, WORD, HWND, BOOL);
		/** Displays the CPU debug dialog.
		  */
		LRESULT OnDebugCpu(WORD, WORD, HWND, BOOL);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Static Functions

		/** Returns the idle time handler.
		  */
		static CIdleHandler* GetIdleHandler();
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Protected Functions

		/** Initializes all of the NeoPSX log files.
		  */
		void InitializeLogFiles() const;
		/** Sets the text of the status bar to the specified value.
		  */
		void SetStatusBarText(int pane, const EFString& message);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Static Protected Variables

		static RECT           mMainWindowRect; ///< The rectangle which defines the size of this window in pixels.
		static PSXIdleHandler mIdleHandler;    ///< The class which handles idle message processing time.

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Protected Variables

		std::auto_ptr<PSXPluginDialog> mPlugin;

		EFString            mWindowTitle; ///< The string which contains the title for the main window.
		EFVersionInfo       mVersion;     ///< The string which describes the version of this application.
		CMenuT<true>        mMenu;        ///< Creates and manages the menu for this window.
		CRecentDocumentList mDocList;     ///< The recent document list for the recent document menu.
	};
} // Namespace NeoPSX

#endif // PSX_MAIN_WINDOW_HPP